

************************************************************
************************************************************
***             Leaving Unemployment                     ***
***     Analyzing the data with panel regressions        ***
***		    Josef Brderl, Volker Ludwig           	     *** 	   
***		             May 2011                            *** 	   
************************************************************
************************************************************

/* Data: SOEP 1984-2009 v26

* We start with file "Unemployment.dta"
* This file was prepared with "Unemployment 1 Retrieval.do"
* File is in episode-month format (monthly episode splitting).

The lecture-package includes an anonymized version of this file:
A 50% random sample (on the person level), with artificial IDs. 
Therefore, results are very similar, but not identical to the ones 
reported in the lecture. */


*************************************
** Preliminaries    *****************
*************************************
clear 
set more off

* Load data
cd  "K:\Vorlesung PDA\Stata Beispiele\"    //Adapt this path!
use "Unemployment.dta", clear

* Preparing the covariates
gen lnt = ln(t)                                    //logarithm of time
recode sex 1=0 2=1, into(female)                   //gender
recode loc1989 1=0 2=1 *=., into(west)             //West German
recode migback 1=0 2 3 4=1 *=., into(migrant)      //migrant 
recode educ -2 -1 = .                              //education
gen miss = missing(west,migrant,educ)              //splits with mv


***************************************************
***   Continuous-time analysis: Cox-regression  ***
***************************************************
gen T0 = t-1                                  //start time of split
stset t, failure(d==1) id(epiid) time0(T0)    //note that dur is here +1!!

***** Pooled Cox *****************
stcox nprev age female west migrant educ spring winter seam y0306, vce(cluster id)  
estimates store Pooled_Cox

***** FE Cox     ***************** 
stcox nprev age       educ spring winter seam y0306 if miss==0, strata(id) efron vce(cluster id)
estimates store FE_Cox


********************************************
*** Discrete-time analysis:  Logit       ***
********************************************

***** Pooled Logit ***************
logit d nprev age female west migrant educ spring winter seam y0306 t lnt, or vce(cluster id)
estimates store Pooled_logit

***** FE Logit     ***************
bysort id (month60): gen splitnr = _n     //split ID (within person)
xtset id splitnr                          //declaring panel data

* vce(cluster) is not allowed with xtlogit, bootstrap takes about 1 hour
xtlogit d nprev age      educ spring winter seam y0306 t lnt if miss==0, fe or
*xtlogit d nprev age      educ spring winter seam y0306 t lnt if miss==0, fe or vce(bootstrap)
estimates store FE_logit


************************************
** Compare estimates ***************
************************************
estimates table Pooled_Cox Pooled_logit FE_Cox FE_logit, ///
      eform star b(%9.2f) stats(N N_sub N_fail N_g ll_0 ll chi2 r2_p) equation(1)

	  
	  
***************************************************
** RE models (shared frailty models)           ****
***************************************************
* RE-Cox: hardly estimable, too manny groups
* stcox nprev age female west migrant educ spring winter seam y0306, shared(id)

* RE-log-logistic
streg nprev age female west migrant educ spring winter seam y0306, dist(ll) shared(id)



/**************************************************
***  Continuous-time EHA without TVCs           ***
***************************************************
* In case one wants to do continuous-time EHA without TVCs: We need only 
* the first split of each episode, which still contains all info needed
preserve
keep if t==1                     //keeping only the first split
gen     dur = exit - entry       //duration in months
replace dur = 0.5 if dur==0      //there must be no dur==0
recode  zensor 2 3 = 0
ltable dur zensor, survival hazard i(0 1 2 3 4 6 8 10 12 24 36)
stset dur, failure(zensor==1) 
sts graph, hazard width(2) ci tmax(48) xsize(4.5)                        ///
       xtitle("duration in months", size(medlarge) margin(0 0 0 2))      ///
	   ytitle("rate of leaving unemployment", size(medlarge))            ///
       xlabel(0(6)48, grid labsize(medium))                              ///
	   ylabel(0(0.02)0.12, angle(0) grid labsize(medium) format(%4.2f))  ///
       legend(off)
sts graph, survival by(sex) ci tmax(48)  xsize(4.5)                      ///
       xtitle("duration in months", size(medlarge) margin(0 0 0 2))      ///
	   ytitle("proportion unemployed", size(medlarge))                   ///
	   xlabel(0(6)48, labsize(medium))                                   ///
	   ylabel(0(0.1)1, angle(0) grid labsize(medium) format(%3.1f))      ///
	   legend(pos(1) ring(0) row(2) order(1 2 3 4) lab(2 "Man")          ///
	     lab(4 "Woman") size(medlarge))     
restore
*/

